/* @license GPL-2.0-or-later https://www.drupal.org/licensing/faq */
(function($,Drupal,drupalSettings){let showWeight=JSON.parse(localStorage.getItem('Drupal.tableDrag.showWeight'));Drupal.behaviors.tableDrag={attach(context,settings){function initTableDrag(table,base){if(table.length)Drupal.tableDrag[base]=new Drupal.tableDrag(table[0],settings.tableDrag[base]);}Object.keys(settings.tableDrag||{}).forEach((base)=>{initTableDrag($(once('tabledrag',`#${base}`,context)),base);});}};Drupal.tableDrag=function(table,tableSettings){const self=this;const $table=$(table);this.$table=$(table);this.table=table;this.tableSettings=tableSettings;this.dragObject=null;this.rowObject=null;this.oldRowElement=null;this.oldY=null;this.changed=false;this.maxDepth=0;this.rtl=window.getComputedStyle(this.table).direction==='rtl'?-1:1;this.striping=$(this.table).data('striping')===1;this.scrollSettings={amount:4,interval:50,trigger:70};this.scrollInterval=null;this.scrollY=0;this.windowHeight=0;this.$toggleWeightButton=null;this.indentEnabled=false;this.changedRowIds=Drupal.tableDrag[table.id]?Drupal.tableDrag[table.id].changedRowIds:new Set();Object.keys(tableSettings||{}).forEach((group)=>{Object.keys(tableSettings[group]||{}).forEach((n)=>{if(tableSettings[group][n].relationship==='parent')this.indentEnabled=true;if(tableSettings[group][n].limit>0)this.maxDepth=tableSettings[group][n].limit;});});this.dragOrientation=this.indentEnabled?'drag':'drag-y';if(this.indentEnabled){const countNestableRows=$table.find('> tr.draggable, > tbody > tr.draggable').not('.tabledrag-leaf').length;if(countNestableRows===0)this.dragOrientation='drag-y';this.indentCount=1;const indent=Drupal.theme('tableDragIndentation');const testRow=$('<tr></tr>').addClass('draggable').appendTo(table);const testCell=$('<td></td>').appendTo(testRow).prepend(indent).prepend(indent);const $indentation=testCell.find('.js-indentation');this.indentAmount=$indentation.get(1).offsetLeft-$indentation.get(0).offsetLeft;testRow.remove();}$table.find('> tr.draggable, > tbody > tr.draggable').each(function(){self.makeDraggable(this);});const $toggleWeightWrapper=$(Drupal.theme('tableDragToggle'));this.$toggleWeightButton=$toggleWeightWrapper.find('[data-drupal-selector="tabledrag-toggle-weight"]');this.$toggleWeightButton.on('click',function(e){e.preventDefault();this.toggleColumns();}.bind(this));$table.before($toggleWeightWrapper);self.initColumns();$(document).on('touchmove',(event)=>self.dragRow(event.originalEvent.touches[0],self));$(document).on('touchend',(event)=>self.dropRow(event.originalEvent.touches[0],self));$(document).on('mousemove pointermove',(event)=>self.dragRow(event,self));$(document).on('mouseup pointerup',(event)=>self.dropRow(event,self));$(window).on('storage',function(e){if(e.originalEvent.key==='Drupal.tableDrag.showWeight'){showWeight=JSON.parse(e.originalEvent.newValue);this.displayColumns(showWeight);}}.bind(this));this.changedRowIds.forEach((changedRowId)=>{const rowObject=new self.row(document.getElementById(changedRowId),'',self.indentEnabled,self.maxDepth,true);rowObject.markChanged();});};Drupal.tableDrag.prototype.initColumns=function(){const $table=this.$table;let hidden;let cell;let columnIndex;Object.keys(this.tableSettings||{}).forEach((group)=>{Object.keys(this.tableSettings[group]).some((tableSetting)=>{const field=$table.find(`.${this.tableSettings[group][tableSetting].target}`).eq(0);if(field.length&&this.tableSettings[group][tableSetting].hidden){hidden=this.tableSettings[group][tableSetting].hidden;cell=field.closest('td');return true;}return false;});if(hidden&&cell[0]){columnIndex=cell.parent().find('> td').index(cell.get(0))+1;$table.find('> thead > tr, > tbody > tr, > tr').each(this.addColspanClass(columnIndex));}});this.displayColumns(showWeight);};Drupal.tableDrag.prototype.addColspanClass=function(columnIndex){return function(){const $row=$(this);let index=columnIndex;const cells=$row.children();let cell;cells.each(function(n){if(n<index&&this.colSpan&&this.colSpan>1)index-=this.colSpan-1;});if(index>0){cell=cells.filter(`:nth-child(${index})`);if(cell[0].colSpan&&cell[0].colSpan>1)cell.addClass('tabledrag-has-colspan');else cell.addClass('tabledrag-hide');}};};Drupal.tableDrag.prototype.displayColumns=function(displayWeight){if(displayWeight)this.showColumns();else this.hideColumns();this.$toggleWeightButton.html(Drupal.theme('toggleButtonContent',displayWeight));$(once.filter('tabledrag','table')).trigger('columnschange',!!displayWeight);};Drupal.tableDrag.prototype.toggleColumns=function(){showWeight=!showWeight;this.displayColumns(showWeight);if(showWeight)localStorage.setItem('Drupal.tableDrag.showWeight',showWeight);else localStorage.removeItem('Drupal.tableDrag.showWeight');};Drupal.tableDrag.prototype.hideColumns=function(){const $tables=$(once.filter('tabledrag','table'));$tables.find('.tabledrag-hide').each(function(){this.style.display='none';});$tables.find('.tabledrag-handle').each(function(){this.style.display='';});$tables.find('.tabledrag-has-colspan').each(function(){this.colSpan-=1;});};Drupal.tableDrag.prototype.showColumns=function(){const $tables=$(once.filter('tabledrag','table'));$tables.find('.tabledrag-hide').each(function(){this.style.display='';});$tables.find('.tabledrag-handle').each(function(){this.style.display='none';});$tables.find('.tabledrag-has-colspan').each(function(){this.colSpan+=1;});};Drupal.tableDrag.prototype.rowSettings=function(group,row){const field=$(row).find(`.${group}`);const tableSettingsGroup=this.tableSettings[group];return Object.keys(tableSettingsGroup).map((delta)=>{const targetClass=tableSettingsGroup[delta].target;let rowSettings;if(field[0].matches(`.${targetClass}`)){rowSettings={};Object.keys(tableSettingsGroup[delta]).forEach((n)=>{rowSettings[n]=tableSettingsGroup[delta][n];});}return rowSettings;}).filter((rowSetting)=>rowSetting)[0];};Drupal.tableDrag.prototype.makeDraggable=function(item){const self=this;const $item=$(item);$item.find('td:first-of-type').find('a').addClass('menu-item__link');const $handle=$(Drupal.theme('tableDragHandle',this.dragOrientation));if(this.dragOrientation==='drag-y')$handle.addClass('tabledrag-handle-y');const $indentationLast=$item.find('td:first-of-type').find('.js-indentation').eq(-1);if($indentationLast.length){$indentationLast.after($handle);self.indentCount=Math.max($item.find('.js-indentation').length,self.indentCount);}else $item.find('td').eq(0).prepend($handle);$handle.on('mousedown touchstart pointerdown',(event)=>{event.preventDefault();if(event.originalEvent.type==='touchstart')event=event.originalEvent.touches[0];self.dragStart(event,self,item);});$handle.on('click',(e)=>{e.preventDefault();});$handle.on('focus',()=>{self.safeBlur=true;});$handle.on('blur',(event)=>{if(self.rowObject&&self.safeBlur)self.dropRow(event,self);});$handle.on('keydown',(event)=>{if(event.keyCode!==9&&!self.rowObject)self.rowObject=new self.row(item,'keyboard',self.indentEnabled,self.maxDepth,true);let keyChange=false;let groupHeight;switch(event.keyCode){case 37:case 63234:keyChange=true;self.rowObject.indent(-1*self.rtl);break;case 38:case 63232:{let $previousRow=$(self.rowObject.element).prev('tr').eq(0);let previousRow=$previousRow.get(0);while(previousRow&&Drupal.elementIsHidden(previousRow)){$previousRow=$(previousRow).prev('tr').eq(0);previousRow=$previousRow.get(0);}if(previousRow){self.safeBlur=false;self.rowObject.direction='up';keyChange=true;if(item.matches('.tabledrag-root')){groupHeight=0;while(previousRow&&$previousRow.find('.js-indentation').length){$previousRow=$(previousRow).prev('tr').eq(0);previousRow=$previousRow.get(0);groupHeight+=Drupal.elementIsHidden(previousRow)?0:previousRow.offsetHeight;}if(previousRow){self.rowObject.swap('before',previousRow);window.scrollBy(0,-groupHeight);}}else{if(self.table.tBodies[0].rows[0]!==previousRow||previousRow.matches('.draggable')){self.rowObject.swap('before',previousRow);self.rowObject.interval=null;self.rowObject.indent(0);window.scrollBy(0,-parseInt(item.offsetHeight,10));}}$handle.trigger('focus');}break;}case 39:case 63235:keyChange=true;self.rowObject.indent(self.rtl);break;case 40:case 63233:{let $nextRow=$(self.rowObject.group).eq(-1).next('tr').eq(0);let nextRow=$nextRow.get(0);while(nextRow&&Drupal.elementIsHidden(nextRow)){$nextRow=$(nextRow).next('tr').eq(0);nextRow=$nextRow.get(0);}if(nextRow){self.safeBlur=false;self.rowObject.direction='down';keyChange=true;if(item.matches('.tabledrag-root')){groupHeight=0;const nextGroup=new self.row(nextRow,'keyboard',self.indentEnabled,self.maxDepth,false);if(nextGroup){$(nextGroup.group).each(function(){groupHeight+=Drupal.elementIsHidden(this)?0:this.offsetHeight;});const nextGroupRow=$(nextGroup.group).eq(-1).get(0);self.rowObject.swap('after',nextGroupRow);window.scrollBy(0,parseInt(groupHeight,10));}}else{self.rowObject.swap('after',nextRow);self.rowObject.interval=null;self.rowObject.indent(0);window.scrollBy(0,parseInt(item.offsetHeight,10));}$handle.trigger('focus');}break;}}if(self.rowObject&&self.rowObject.changed===true){$(item).addClass('drag');if(self.oldRowElement)$(self.oldRowElement).removeClass('drag-previous');self.oldRowElement=item;if(self.striping===true)self.restripeTable();self.onDrag();}if(keyChange)return false;});$handle.on('keypress',(event)=>{switch(event.keyCode){case 37:case 38:case 39:case 40:return false;}});};Drupal.tableDrag.prototype.dragStart=function(event,self,item){self.dragObject={};self.dragObject.initOffset=self.getPointerOffset(item,event);self.dragObject.initPointerCoords=self.pointerCoords(event);if(self.indentEnabled)self.dragObject.indentPointerPos=self.dragObject.initPointerCoords;if(self.rowObject)$(self.rowObject.element).find('a.tabledrag-handle').trigger('blur');self.rowObject=new self.row(item,'pointer',self.indentEnabled,self.maxDepth,true);self.table.topY=$(self.table).offset().top;self.table.bottomY=self.table.topY+self.table.offsetHeight;$(item).addClass('drag');$('body').addClass(this.dragOrientation);if(self.oldRowElement)$(self.oldRowElement).removeClass('drag-previous');self.oldY=self.pointerCoords(event).y;};Drupal.tableDrag.prototype.dragRow=function(event,self){if(self.dragObject){self.currentPointerCoords=self.pointerCoords(event);const y=self.currentPointerCoords.y-self.dragObject.initOffset.y;const x=self.currentPointerCoords.x-self.dragObject.initOffset.x;if(y!==self.oldY){self.rowObject.direction=y>self.oldY?'down':'up';self.oldY=y;const scrollAmount=self.checkScroll(self.currentPointerCoords.y);clearInterval(self.scrollInterval);if((scrollAmount>0&&self.rowObject.direction==='down')||(scrollAmount<0&&self.rowObject.direction==='up'))self.setScroll(scrollAmount);const currentRow=self.findDropTargetRow(x,y);if(currentRow){if(self.rowObject.direction==='down')self.rowObject.swap('after',currentRow,self);else self.rowObject.swap('before',currentRow,self);if(self.striping===true)self.restripeTable();}}if(self.indentEnabled){const xDiff=self.currentPointerCoords.x-self.dragObject.indentPointerPos.x;const indentDiff=Math.round(xDiff/self.indentAmount);const indentChange=self.rowObject.indent(indentDiff);self.dragObject.indentPointerPos.x+=self.indentAmount*indentChange*self.rtl;self.indentCount=Math.max(self.indentCount,self.rowObject.indents);}return false;}};Drupal.tableDrag.prototype.dropRow=function(event,self){let droppedRow;let $droppedRow;if(self.rowObject!==null){droppedRow=self.rowObject.element;$droppedRow=$(droppedRow);if(self.rowObject.changed===true){self.updateFields(droppedRow);Object.keys(self.tableSettings||{}).forEach((group)=>{const rowSettings=self.rowSettings(group,droppedRow);if(rowSettings.relationship==='group')Object.keys(self.rowObject.children||{}).forEach((n)=>{self.updateField(self.rowObject.children[n],group);});});self.rowObject.markChanged();if(self.changed===false){self.rowObject.addChangedWarning();self.changed=true;}}if(self.indentEnabled)self.rowObject.removeIndentClasses();if(self.oldRowElement)$(self.oldRowElement).removeClass('drag-previous');$droppedRow.removeClass('drag').addClass('drag-previous');self.oldRowElement=droppedRow;self.onDrop();self.rowObject=null;}if(self.dragObject!==null){self.dragObject=null;$('body').removeClass(self.dragOrientation);clearInterval(self.scrollInterval);}};Drupal.tableDrag.prototype.pointerCoords=function(event){if(event.pageX||event.pageY)return {x:event.pageX,y:event.pageY};return {x:event.clientX+document.body.scrollLeft-document.body.clientLeft,y:event.clientY+document.body.scrollTop-document.body.clientTop};};Drupal.tableDrag.prototype.getPointerOffset=function(target,event){const docPos=$(target).offset();const pointerPos=this.pointerCoords(event);return {x:pointerPos.x-docPos.left,y:pointerPos.y-docPos.top};};Drupal.tableDrag.prototype.findDropTargetRow=function(x,y){const rows=$(this.table.tBodies[0].rows).not(':hidden');for(let n=0;n<rows.length;n++){let row=rows[n];let $row=$(row);const rowY=$row.offset().top;let rowHeight;if(row.offsetHeight===0)rowHeight=parseInt(row.firstChild.offsetHeight,10)/2;else rowHeight=parseInt(row.offsetHeight,10)/2;if(y>rowY-rowHeight&&y<rowY+rowHeight){if(this.indentEnabled){if(Object.keys(this.rowObject.group).some((o)=>this.rowObject.group[o]===row))return null;}else{if(row===this.rowObject.element)return null;}if(!this.rowObject.isValidSwap(row))return null;while(Drupal.elementIsHidden(row)&&Drupal.elementIsHidden($row.prev('tr')[0])){$row=$row.prev('tr:first-of-type');row=$row.get(0);}return row;}}return null;};Drupal.tableDrag.prototype.updateFields=function(changedRow){Object.keys(this.tableSettings||{}).forEach((group)=>{this.updateField(changedRow,group);});};Drupal.tableDrag.prototype.updateField=function(changedRow,group){let rowSettings=this.rowSettings(group,changedRow);const $changedRow=$(changedRow);let sourceRow;let $previousRow;let previousRow;let useSibling;if(rowSettings.relationship==='self'||rowSettings.relationship==='group')sourceRow=changedRow;else if(rowSettings.relationship==='sibling'){$previousRow=$changedRow.prev('tr:first-of-type');previousRow=$previousRow.get(0);const $nextRow=$changedRow.next('tr:first-of-type');const nextRow=$nextRow.get(0);sourceRow=changedRow;if(previousRow?.matches('.draggable')&&$previousRow.find(`.${group}`).length)if(this.indentEnabled){if($previousRow.find('.js-indentations').length===$changedRow.find('.js-indentations').length)sourceRow=previousRow;}else sourceRow=previousRow;else{if(nextRow?.matches('.draggable')&&$nextRow.find(`.${group}`).length)if(this.indentEnabled){if($nextRow.find('.js-indentations').length===$changedRow.find('.js-indentations').length)sourceRow=nextRow;}else sourceRow=nextRow;}}else{if(rowSettings.relationship==='parent'){$previousRow=$changedRow.prev('tr');previousRow=$previousRow;while($previousRow.length&&$previousRow.find('.js-indentation').length>=this.rowObject.indents){$previousRow=$previousRow.prev('tr');previousRow=$previousRow;}if($previousRow.length)sourceRow=$previousRow.get(0);else{sourceRow=$(this.table).find('tr.draggable:first-of-type').get(0);if(sourceRow===this.rowObject.element)sourceRow=$(this.rowObject.group[this.rowObject.group.length-1]).next('tr.draggable').get(0);useSibling=true;}}}this.copyDragClasses(sourceRow,changedRow,group);rowSettings=this.rowSettings(group,changedRow);if(useSibling){rowSettings.relationship='sibling';rowSettings.source=rowSettings.target;}const targetClass=`.${rowSettings.target}`;const targetElement=$changedRow.find(targetClass).get(0);if(targetElement){const sourceClass=`.${rowSettings.source}`;const sourceElement=$(sourceClass,sourceRow).get(0);switch(rowSettings.action){case 'depth':targetElement.value=$(sourceElement).closest('tr').find('.js-indentation').length;break;case 'match':targetElement.value=sourceElement.value;break;case 'order':{const siblings=this.rowObject.findSiblings(rowSettings);if(targetElement.tagName==='SELECT'){const values=[];$(targetElement).find('option').each(function(){values.push(this.value);});const maxVal=values[values.length-1];$(siblings).find(targetClass).each(function(){if(values.length>0)this.value=values.shift();else this.value=maxVal;});}else{let weight=0;const $siblingTarget=$(siblings[0]).find(targetClass);if($siblingTarget.length)weight=parseInt($siblingTarget[0].value,10)||0;$(siblings).find(targetClass).each(function(){this.value=weight;weight++;});}break;}}}};Drupal.tableDrag.prototype.copyDragClasses=function(sourceRow,targetRow,group){const sourceElement=$(sourceRow).find(`.${group}`);const targetElement=$(targetRow).find(`.${group}`);if(sourceElement.length&&targetElement.length)targetElement[0].className=sourceElement[0].className;};Drupal.tableDrag.prototype.checkScroll=function(cursorY){const de=document.documentElement;const b=document.body;const windowHeight=window.innerHeight||(de.clientHeight&&de.clientWidth!==0?de.clientHeight:b.offsetHeight);this.windowHeight=windowHeight;const scrollY=window.scrollY;this.scrollY=scrollY;const trigger=this.scrollSettings.trigger;let delta=0;if(cursorY-scrollY>windowHeight-trigger){delta=trigger/(windowHeight+scrollY-cursorY);delta=delta>0&&delta<trigger?delta:trigger;return delta*this.scrollSettings.amount;}if(cursorY-scrollY<trigger){delta=trigger/(cursorY-scrollY);delta=delta>0&&delta<trigger?delta:trigger;return -delta*this.scrollSettings.amount;}};Drupal.tableDrag.prototype.setScroll=function(scrollAmount){const self=this;this.scrollInterval=setInterval(()=>{self.checkScroll(self.currentPointerCoords.y);const aboveTable=self.scrollY>self.table.topY;const belowTable=self.scrollY+self.windowHeight<self.table.bottomY;if((scrollAmount>0&&belowTable)||(scrollAmount<0&&aboveTable))window.scrollBy(0,scrollAmount);},this.scrollSettings.interval);};Drupal.tableDrag.prototype.restripeTable=function(){$(this.table).find('> tbody > tr.draggable, > tr.draggable').filter(':visible').filter(':odd').removeClass('odd').addClass('even').end().filter(':even').removeClass('even').addClass('odd');};Drupal.tableDrag.prototype.onDrag=function(){return null;};Drupal.tableDrag.prototype.onDrop=function(){return null;};Drupal.tableDrag.prototype.row=function(tableRow,method,indentEnabled,maxDepth,addClasses){const $tableRow=$(tableRow);this.element=tableRow;this.method=method;this.group=[tableRow];this.groupDepth=$tableRow.find('.js-indentation').length;this.changed=false;this.table=$tableRow.closest('table')[0];this.indentEnabled=indentEnabled;this.maxDepth=maxDepth;this.direction='';if(this.indentEnabled){this.indents=$tableRow.find('.js-indentation').length;this.children=this.findChildren(addClasses);this.group=this.group.concat(this.children);for(let n=0;n<this.group.length;n++)this.groupDepth=Math.max($(this.group[n]).find('.js-indentation').length,this.groupDepth);}};Drupal.tableDrag.prototype.row.prototype.addChangedWarning=function(){if(!$(this.table.parentNode).find('.tabledrag-changed-warning').length){const $form=$(this.table).closest('form');$(Drupal.theme('tableDragChangedWarning')).insertBefore(this.table).hide().fadeIn($form[0].hasAttribute('data-tabledrag-save-warning')?0:'slow');$form[0].setAttribute('data-tabledrag-save-warning',true);}};Drupal.tableDrag.prototype.row.prototype.findChildren=function(addClasses){const parentIndentation=this.indents;let currentRow=$(this.element,this.table).next('tr.draggable');const rows=[];let child=0;function rowIndentation(indentNum,el){const self=$(el);if(child===1&&indentNum===parentIndentation)self.addClass('tree-child-first');if(indentNum===parentIndentation)self.addClass('tree-child');else{if(indentNum>parentIndentation)self.addClass('tree-child-horizontal');}}while(currentRow.length){if(currentRow.find('.js-indentation').length>parentIndentation){child++;rows.push(currentRow[0]);if(addClasses)currentRow.find('.js-indentation').each(rowIndentation);}else break;currentRow=currentRow.next('tr.draggable');}if(addClasses&&rows.length)$(rows[rows.length-1]).find(`.js-indentation:nth-child(${parentIndentation+1})`).addClass('tree-child-last');return rows;};Drupal.tableDrag.prototype.row.prototype.isValidSwap=function(row){const $row=$(row);if(this.indentEnabled){let prevRow;let nextRow;if(this.direction==='down'){prevRow=row;nextRow=$row.next('tr').get(0);}else{prevRow=$row.prev('tr').get(0);nextRow=row;}this.interval=this.validIndentInterval(prevRow,nextRow);if(this.interval.min>this.interval.max)return false;}if(this.table.tBodies[0].rows[0]===row&&!row.matches('.draggable'))return false;return true;};Drupal.tableDrag.prototype.row.prototype.swap=function(position,row){this.group.forEach((row)=>{Drupal.detachBehaviors(row,drupalSettings,'move');});$(row)[position](this.group);this.group.forEach((row)=>{Drupal.attachBehaviors(row,drupalSettings);});this.changed=true;this.onSwap(row);};Drupal.tableDrag.prototype.row.prototype.validIndentInterval=function(prevRow,nextRow){const $prevRow=$(prevRow);let maxIndent;const minIndent=nextRow?$(nextRow).find('.js-indentation').length:0;if(!prevRow||!prevRow.matches('.draggable')||this.element.matches('.tabledrag-root'))maxIndent=0;else{maxIndent=$prevRow.find('.js-indentation').length+(prevRow.matches('.tabledrag-leaf')?0:1);if(this.maxDepth)maxIndent=Math.min(maxIndent,this.maxDepth-(this.groupDepth-this.indents));}return {min:minIndent,max:maxIndent};};Drupal.tableDrag.prototype.row.prototype.indent=function(indentDiff){const $group=$(this.group);if(!this.interval){const prevRow=$(this.element).prev('tr').get(0);const nextRow=$group.eq(-1).next('tr').get(0);this.interval=this.validIndentInterval(prevRow,nextRow);}let indent=this.indents+indentDiff;indent=Math.max(indent,this.interval.min);indent=Math.min(indent,this.interval.max);indentDiff=indent-this.indents;for(let n=1;n<=Math.abs(indentDiff);n++)if(indentDiff<0){$group.find('.js-indentation:first-of-type').remove();this.indents--;}else{$group.find('td:first-of-type').prepend(Drupal.theme('tableDragIndentation'));this.indents++;}if(indentDiff){this.changed=true;this.groupDepth+=indentDiff;this.onIndent();}return indentDiff;};Drupal.tableDrag.prototype.row.prototype.findSiblings=function(rowSettings){const siblings=[];const directions=['prev','next'];const rowIndentation=this.indents;let checkRowIndentation;for(let d=0;d<directions.length;d++){let checkRow=$(this.element)[directions[d]]();while(checkRow.length){if(checkRow.find(`.${rowSettings.target}`)){if(this.indentEnabled)checkRowIndentation=checkRow.find('.js-indentation').length;if(!this.indentEnabled||checkRowIndentation===rowIndentation)siblings.push(checkRow[0]);else{if(checkRowIndentation<rowIndentation)break;}}else break;checkRow=checkRow[directions[d]]();}if(directions[d]==='prev'){siblings.reverse();siblings.push(this.element);}}return siblings;};Drupal.tableDrag.prototype.row.prototype.removeIndentClasses=function(){Object.keys(this.children||{}).forEach((n)=>{$(this.children[n]).find('.js-indentation').removeClass('tree-child').removeClass('tree-child-first').removeClass('tree-child-last').removeClass('tree-child-horizontal');});};Drupal.tableDrag.prototype.row.prototype.markChanged=function(){const marker=Drupal.theme('tableDragChangedMarker');const cell=$(this.element).find('td:first-of-type');if(cell.find('abbr.tabledrag-changed').length===0)cell.append(marker);Drupal.tableDrag[this.table.id].changedRowIds.add(this.element.id);};Drupal.tableDrag.prototype.row.prototype.onIndent=function(){return null;};Drupal.tableDrag.prototype.row.prototype.onSwap=function(swappedRow){return null;};$.extend(Drupal.theme,{tableDragChangedMarker(){return `<abbr class="warning tabledrag-changed" title="${Drupal.t('Changed')}">*</abbr>`;},tableDragIndentation(){return '<div class="js-indentation indentation">&nbsp;</div>';},tableDragChangedWarning(){return `<div class="tabledrag-changed-warning messages messages--warning" role="alert">${Drupal.theme('tableDragChangedMarker')} ${Drupal.t('You have unsaved changes.')}</div>`;},tableDragToggle:()=>`<div class="tabledrag-toggle-weight-wrapper" data-drupal-selector="tabledrag-toggle-weight-wrapper">
            <button type="button" class="link tabledrag-toggle-weight" data-drupal-selector="tabledrag-toggle-weight"></button>
            </div>`,toggleButtonContent:(show)=>show?Drupal.t('Hide row weights'):Drupal.t('Show row weights'),tableDragHandle(dragOrientation='drag'){const title=dragOrientation==='drag-y'?Drupal.t('Change order'):Drupal.t('Move in any direction');return `<a href="#" title="${title}"
        class="tabledrag-handle"><div class="handle"></div></a>`;}});})(jQuery,Drupal,drupalSettings);;
function rgb2hex(orig){var rgb=orig.replace(/\s/g,'').match(/^rgba?\((\d+),(\d+),(\d+)/i);return (rgb&&rgb.length===4)?"#"+("0"+parseInt(rgb[1],10).toString(16)).slice(-2)+("0"+parseInt(rgb[2],10).toString(16)).slice(-2)+("0"+parseInt(rgb[3],10).toString(16)).slice(-2):orig;}var getContrast=function(hexcolor){if(hexcolor.slice(0,1)==='#')hexcolor=hexcolor.slice(1);if(hexcolor.length===3)hexcolor=hexcolor.split('').map(function(hex){return hex+hex;}).join('');var r=parseInt(hexcolor.substr(0,2),16);var g=parseInt(hexcolor.substr(2,2),16);var b=parseInt(hexcolor.substr(4,2),16);var yiq=((r*299)+(g*587)+(b*114))/1000;return (yiq>=128)?'dark':'light';};;
(function($,Drupal,once){"use strict";Drupal.behaviors.backgroundColorLayoutBuilderForm={attach:function(context){once('blb_bg-color',".fieldgroup.field-background-color input[type=radio]",context).forEach(function(value,i){if($(value).val()!='_none'){$(value).next('label').addClass($(value).val());var bgColor=$(value).next('label').css('background-color');var bgColorHex=rgb2hex(bgColor);var bgColorContrast=getContrast(bgColorHex);$(value).next('label').addClass('bs_yiq-'+bgColorContrast);}});$(".fieldgroup.field-background-color .fieldset-wrapper label",context).on('click',function(){$(this).parents('.fieldset-wrapper').find('label').removeClass('active');$(this).parents('.fieldset-wrapper').addClass('style-selected').find('input').prop("checked",false);if($(this).hasClass('_none'))$(this).parents('.fieldset-wrapper').removeClass('style-selected');});$(".fieldgroup.field-background-color .fieldset-wrapper input:radio",context).each(function(){$(this).closest('.radio').find('label').addClass($(this).val());var checked=$(this).prop("checked");if(typeof checked!==typeof undefined&&checked!==false)$(this).closest('.radio').find('label').addClass('active');});}};})(jQuery,Drupal,once);;
(function($,Drupal,once){"use strict";Drupal.behaviors.textColorLayoutBuilderForm={attach:function(context){once('blb_text-color',".fieldgroup.field-text-color input[type=radio]",context).forEach(function(value,i){$(value).next('label').addClass($(value).val());if($(value).val()!='_none'){var label_color=$(value).next('label').css('color');$(value).next('label').css('background-color',label_color);var bgColor=$(value).next('label').css('background-color');var bgColorHex=rgb2hex(bgColor);var bgColorContrast=getContrast(bgColorHex);$(value).next('label').addClass('bs_yiq-'+bgColorContrast);}});$(".fieldgroup.field-text-color .fieldset-wrapper label",context).on('click',function(){$(this).parents('.fieldset-wrapper').find('label').removeClass('active');if($(this).hasClass('_none'))$(this).parents('.fieldset-wrapper').removeClass('style-selected');});$(".fieldgroup.field-text-color .fieldset-wrapper input:radio",context).each(function(){$(this).closest('.radio').find('label').addClass($(this).val());var checked=$(this).prop("checked");if(typeof checked!==typeof undefined&&checked!==false)$(this).closest('.radio').find('label').addClass('active');});}};})(jQuery,Drupal,once);;
(function($,Drupal,once){"use strict";Drupal.behaviors.spacingPreview={attach:function(context,settings){var spacing=settings.bootstrap_styles.spacing;var breakpoints=settings.bootstrap_styles.breakpoints;var padding_box_shadow=$('.spacing-preview .padding-box').css('box-shadow');var margin_box_shadow=$('.spacing-preview .margin-box').css('box-shadow');var box_shadow='0 0 0 1.5rem';function calcPadding(){var padding_val=$('input.bs-field-padding').val();var padding_left_val=$('input.bs-field-padding-left').val();var padding_top_val=$('input.bs-field-padding-top').val();var padding_right_val=$('input.bs-field-padding-right').val();var padding_bottom_val=$('input.bs-field-padding-bottom').val();var padding_classes='';var padding_class=spacing.padding_classes_options.padding[padding_val];if(padding_class!='_none')padding_classes+=padding_class+' ';var padding_left_class=spacing.padding_classes_options.padding_left[padding_left_val];if(padding_left_class!='_none')padding_classes+=padding_left_class+' ';var padding_top_class=spacing.padding_classes_options.padding_top[padding_top_val];if(padding_top_class!='_none')padding_classes+=padding_top_class+' ';var padding_right_class=spacing.padding_classes_options.padding_right[padding_right_val];if(padding_right_class!='_none')padding_classes+=padding_right_class+' ';var padding_bottom_class=spacing.padding_classes_options.padding_bottom[padding_bottom_val];if(padding_bottom_class!='_none')padding_classes+=padding_bottom_class+' ';padding_classes+=getActiveBreakpointPaddingClasses();$('#bs_spacing_preview_calc').removeClass();$('#bs_spacing_preview_calc').addClass(padding_classes);$('.spacing-preview .padding-left').text(parseInt($('#bs_spacing_preview_calc').css('padding-left')));$('.spacing-preview .padding-top').text(parseInt($('#bs_spacing_preview_calc').css('padding-top')));$('.spacing-preview .padding-right').text(parseInt($('#bs_spacing_preview_calc').css('padding-right')));$('.spacing-preview .padding-bottom').text(parseInt($('#bs_spacing_preview_calc').css('padding-bottom')));}function getActiveBreakpointPaddingClasses(){var padding_classes='';var active_breakpoint=$('.bs_responsive_spacing input:checked').val();if(typeof active_breakpoint!=='undefined'){var i;var padding_classes='';for(i=0;i<breakpoints.length;i++)if(active_breakpoint==breakpoints[i]){var padding_val=$('input.bs-field-padding-'+breakpoints[i]).val();var padding_left_val=$('input.bs-field-padding-left-'+breakpoints[i]).val();var padding_top_val=$('input.bs-field-padding-top-'+breakpoints[i]).val();var padding_right_val=$('input.bs-field-padding-right-'+breakpoints[i]).val();var padding_bottom_val=$('input.bs-field-padding-bottom-'+breakpoints[i]).val();var padding_class=spacing.padding_classes_options['padding_'+breakpoints[i]][padding_val];if(padding_class!='_none')padding_classes+=padding_class+' ';var padding_left_class=spacing.padding_classes_options['padding_left_'+breakpoints[i]][padding_left_val];if(padding_left_class!='_none')padding_classes+=padding_left_class+' ';var padding_top_class=spacing.padding_classes_options['padding_top_'+breakpoints[i]][padding_top_val];if(padding_top_class!='_none')padding_classes+=padding_top_class+' ';var padding_right_class=spacing.padding_classes_options['padding_right_'+breakpoints[i]][padding_right_val];if(padding_right_class!='_none')padding_classes+=padding_right_class+' ';var padding_bottom_class=spacing.padding_classes_options['padding_bottom_'+breakpoints[i]][padding_bottom_val];if(padding_bottom_class!='_none')padding_classes+=padding_bottom_class+' ';}}return padding_classes;}function calcMargin(){var margin_val=$('input.bs-field-margin').val();var margin_left_val=$('input.bs-field-margin-left').val();var margin_top_val=$('input.bs-field-margin-top').val();var margin_right_val=$('input.bs-field-margin-right').val();var margin_bottom_val=$('input.bs-field-margin-bottom').val();var margin_classes='';var margin_class=spacing.margin_classes_options.margin[margin_val];if(margin_class!='_none')margin_classes+=margin_class+' ';var margin_left_class=spacing.margin_classes_options.margin_left[margin_left_val];if(margin_left_class!='_none')margin_classes+=margin_left_class+' ';var margin_top_class=spacing.margin_classes_options.margin_top[margin_top_val];if(margin_top_class!='_none')margin_classes+=margin_top_class+' ';var margin_right_class=spacing.margin_classes_options.margin_right[margin_right_val];if(margin_right_class!='_none')margin_classes+=margin_right_class+' ';var margin_bottom_class=spacing.margin_classes_options.margin_bottom[margin_bottom_val];if(margin_bottom_class!='_none')margin_classes+=margin_bottom_class+' ';$('#bs_spacing_preview_calc').removeClass();$('#bs_spacing_preview_calc').addClass(margin_classes);$('.spacing-preview .margin-left').text(parseInt($('#bs_spacing_preview_calc').css('margin-left')));$('.spacing-preview .margin-top').text(parseInt($('#bs_spacing_preview_calc').css('margin-top')));$('.spacing-preview .margin-right').text(parseInt($('#bs_spacing_preview_calc').css('margin-right')));$('.spacing-preview .margin-bottom').text(parseInt($('#bs_spacing_preview_calc').css('margin-bottom')));}calcPadding();calcMargin();$('input[class^="bs-field-padding"], .bs_responsive_spacing input',context).on('change',function(){calcPadding();});$('input[class^="bs-field-padding"]',context).on('focus',function(){var panel_bg=$(this).parents('details').find('summary').css('background-color');var inactive_box_shadow=box_shadow+' '+panel_bg;$('.spacing-preview .margin-box').css('box-shadow',inactive_box_shadow);$('.spacing-preview .padding-box').addClass('bs-adjusting');});$('input[class^="bs-field-padding"]',context).on('focusout',function(){$('.spacing-preview .margin-box').css('box-shadow',margin_box_shadow);$('.spacing-preview .padding-box').removeClass('bs-adjusting');});$('input[class^="bs-field-margin"]',context).on('change',function(){calcMargin();});$('input[class^="bs-field-margin"]',context).on('focus',function(){var panel_bg=$(this).parents('details').find('summary').css('background-color');var inactive_box_shadow=box_shadow+' '+panel_bg;$('.spacing-preview .padding-box').css('box-shadow',inactive_box_shadow);$('.spacing-preview .margin-box').addClass('bs-adjusting');});$('input[class^="bs-field-margin"]',context).on('focusout',function(){$('.spacing-preview .padding-box').css('box-shadow',padding_box_shadow);$('.spacing-preview .margin-box').removeClass('bs-adjusting');});}};})(jQuery,Drupal,once);;
(function($,Drupal){const states={postponed:[]};Drupal.states=states;function invert(a,invertState){return invertState&&typeof a!=='undefined'?!a:a;}function compare(a,b){if(a===b)return typeof a==='undefined'?a:true;return typeof a==='undefined'||typeof b==='undefined';}function ternary(a,b){if(typeof a==='undefined')return b;if(typeof b==='undefined')return a;return a&&b;}Drupal.behaviors.states={attach(context,settings){const elements=once('states','[data-drupal-states]',context);const il=elements.length;for(let i=0;i<il;i++){const config=JSON.parse(elements[i].getAttribute('data-drupal-states'));Object.keys(config||{}).forEach((state)=>{new states.Dependent({element:$(elements[i]),state:states.State.sanitize(state),constraints:config[state]});});}while(states.postponed.length)states.postponed.shift()();}};states.Dependent=function(args){$.extend(this,{values:{},oldValue:null},args);this.dependees=this.getDependees();Object.keys(this.dependees||{}).forEach((selector)=>{this.initializeDependee(selector,this.dependees[selector]);});};states.Dependent.comparisons={RegExp(reference,value){return reference.test(value);},Function(reference,value){return reference(value);},Array(reference,value){if(!Array.isArray(value))return false;return JSON.stringify(reference.sort())===JSON.stringify(value.sort());},Number(reference,value){return typeof value==='string'?compare(reference.toString(),value):compare(reference,value);}};states.Dependent.prototype={initializeDependee(selector,dependeeStates){this.values[selector]={};Object.keys(dependeeStates).forEach((i)=>{let state=dependeeStates[i];if($.inArray(state,dependeeStates)===-1)return;state=states.State.sanitize(state);this.values[selector][state.name]=null;$(selector).on(`state:${state}`,{selector,state},(e)=>{this.update(e.data.selector,e.data.state,e.value);});new states.Trigger({selector,state});});},compare(reference,selector,state){const value=this.values[selector][state.name];if(reference.constructor.name in states.Dependent.comparisons)return states.Dependent.comparisons[reference.constructor.name](reference,value);return compare(reference,value);},update(selector,state,value){if(value!==this.values[selector][state.name]){this.values[selector][state.name]=value;this.reevaluate();}},reevaluate(){let value=this.verifyConstraints(this.constraints);if(value!==this.oldValue){this.oldValue=value;value=invert(value,this.state.invert);this.element.trigger({type:`state:${this.state}`,value,trigger:true});}},verifyConstraints(constraints,selector){let result;if(Array.isArray(constraints)){const hasXor=$.inArray('xor',constraints)===-1;const len=constraints.length;for(let i=0;i<len;i++)if(constraints[i]!=='xor'){const constraint=this.checkConstraints(constraints[i],selector,i);if(constraint&&(hasXor||result))return hasXor;result=result||constraint;}}else{if($.isPlainObject(constraints)){for(const n in constraints)if(constraints.hasOwnProperty(n)){result=ternary(result,this.checkConstraints(constraints[n],selector,n));if(result===false)return false;}}}return result;},checkConstraints(value,selector,state){if(typeof state!=='string'||/[0-9]/.test(state[0]))state=null;else{if(typeof selector==='undefined'){selector=state;state=null;}}if(state!==null){state=states.State.sanitize(state);return invert(this.compare(value,selector,state),state.invert);}return this.verifyConstraints(value,selector);},getDependees(){const cache={};const _compare=this.compare;this.compare=function(reference,selector,state){(cache[selector]||(cache[selector]=[])).push(state.name);};this.verifyConstraints(this.constraints);this.compare=_compare;return cache;}};states.Trigger=function(args){$.extend(this,args);if(this.state in states.Trigger.states){this.element=$(this.selector);if(!this.element.data(`trigger:${this.state}`))this.initialize();}};states.Trigger.prototype={initialize(){const trigger=states.Trigger.states[this.state];if(typeof trigger==='function')trigger.call(window,this.element);else Object.keys(trigger||{}).forEach((event)=>{this.defaultTrigger(event,trigger[event]);});this.element.data(`trigger:${this.state}`,true);},defaultTrigger(event,valueFn){let oldValue=valueFn.call(this.element);this.element.on(event,function(e){const value=valueFn.call(this.element,e);if(oldValue!==value){this.element.trigger({type:`state:${this.state}`,value,oldValue});oldValue=value;}}.bind(this));states.postponed.push(function(){this.element.trigger({type:`state:${this.state}`,value:oldValue,oldValue:null});}.bind(this));}};states.Trigger.states={empty:{keyup(){return this.val()==='';},change(){return this.val()==='';}},checked:{change(){let checked=false;this.each(function(){checked=$(this).prop('checked');return !checked;});return checked;}},value:{keyup(){if(this.length>1)return this.filter(':checked').val()||false;return this.val();},change(){if(this.length>1)return this.filter(':checked').val()||false;return this.val();}},collapsed:{collapsed(e){return typeof e!=='undefined'&&'value' in e?e.value:!this[0].hasAttribute('open');}}};states.State=function(state){this.pristine=state;this.name=state;let process=true;do{while(this.name.charAt(0)==='!'){this.name=this.name.substring(1);this.invert=!this.invert;}if(this.name in states.State.aliases)this.name=states.State.aliases[this.name];else process=false;}while(process);};states.State.sanitize=function(state){if(state instanceof states.State)return state;return new states.State(state);};states.State.aliases={enabled:'!disabled',invisible:'!visible',invalid:'!valid',untouched:'!touched',optional:'!required',filled:'!empty',unchecked:'!checked',irrelevant:'!relevant',expanded:'!collapsed',open:'!collapsed',closed:'collapsed',readwrite:'!readonly'};states.State.prototype={invert:false,toString(){return this.name;}};const $document=$(document);$document.on('state:disabled',(e)=>{const tagsSupportDisable='button, fieldset, optgroup, option, select, textarea, input';if(e.trigger)$(e.target).closest('.js-form-item, .js-form-submit, .js-form-wrapper').toggleClass('form-disabled',e.value).find(tagsSupportDisable).addBack(tagsSupportDisable).prop('disabled',e.value);});$document.on('state:readonly',(e)=>{if(e.trigger)$(e.target).closest('.js-form-item, .js-form-submit, .js-form-wrapper').toggleClass('form-readonly',e.value).find('input, textarea').prop('readonly',e.value);});$document.on('state:required',(e)=>{if(e.trigger)if(e.value){const label=`label${e.target.id?`[for=${e.target.id}]`:''}`;const $label=$(e.target).attr({required:'required'}).closest('.js-form-item, .js-form-wrapper').find(label);if(!$label.hasClass('js-form-required').length)$label.addClass('js-form-required form-required');}else $(e.target).removeAttr('required').closest('.js-form-item, .js-form-wrapper').find('label.js-form-required').removeClass('js-form-required form-required');});$document.on('state:visible',(e)=>{if(e.trigger){let $element=$(e.target).closest('.js-form-item, .js-form-submit, .js-form-wrapper');if(e.target.tagName==='A')$element=$(e.target);$element.toggle(e.value);}});$document.on('state:checked',(e)=>{if(e.trigger)$(e.target).closest('.js-form-item, .js-form-wrapper').find('input').prop('checked',e.value).trigger('change');});$document.on('state:collapsed',(e)=>{if(e.trigger)if(e.target.hasAttribute('open')===e.value)$(e.target).find('> summary').trigger('click');});})(jQuery,Drupal);;
(function($,Drupal,window){function TableResponsive(table){this.table=table;this.$table=$(table);this.showText=Drupal.t('Show all columns');this.hideText=Drupal.t('Hide lower priority columns');this.$headers=this.$table.find('th');this.$link=$('<button type="button" class="link tableresponsive-toggle"></button>').attr('title',Drupal.t('Show table cells that were hidden to make the table fit within a small screen.')).on('click',this.eventhandlerToggleColumns.bind(this));this.$table.before($('<div class="tableresponsive-toggle-columns"></div>').append(this.$link));$(window).on('resize.tableresponsive',this.eventhandlerEvaluateColumnVisibility.bind(this));}Drupal.behaviors.tableResponsive={attach(context,settings){once('tableresponsive','table.responsive-enabled',context).forEach((table)=>{TableResponsive.tables.push(new TableResponsive(table));});if(TableResponsive.tables.length)$(window).trigger('resize.tableresponsive');}};$.extend(TableResponsive,{tables:[]});$.extend(TableResponsive.prototype,{eventhandlerEvaluateColumnVisibility(e){const pegged=parseInt(this.$link.data('pegged'),10);const hiddenLength=this.$headers.filter('.priority-medium:hidden, .priority-low:hidden').length;if(hiddenLength>0){this.$link.show();this.$link[0].textContent=this.showText;}if(!pegged&&hiddenLength===0){this.$link.hide();this.$link[0].textContent=this.hideText;}},eventhandlerToggleColumns(e){e.preventDefault();const self=this;const $hiddenHeaders=this.$headers.filter('.priority-medium:hidden, .priority-low:hidden');this.$revealedCells=this.$revealedCells||$();if($hiddenHeaders.length>0){$hiddenHeaders.each(function(index,element){const $header=$(this);const position=$header.prevAll('th').length;self.$table.find('tbody tr').each(function(){const $cells=$(this).find('td').eq(position);$cells.show();self.$revealedCells=$().add(self.$revealedCells).add($cells);});$header.show();self.$revealedCells=$().add(self.$revealedCells).add($header);});this.$link[0].textContent=this.hideText;this.$link.data('pegged',1);}else{this.$revealedCells.hide();this.$revealedCells.each(function(index,element){const $cell=$(this);const properties=$cell.attr('style').split(';');const newProps=[];const match=/^display\s*:\s*none$/;for(let i=0;i<properties.length;i++){const prop=properties[i];prop.trim();const isDisplayNone=match.exec(prop);if(isDisplayNone)continue;newProps.push(prop);}$cell.attr('style',newProps.join(';'));});this.$link[0].textContent=this.showText;this.$link.data('pegged',0);$(window).trigger('resize.tableresponsive');}}});Drupal.TableResponsive=TableResponsive;})(jQuery,Drupal,window);;
/* @license GPL-2.0-or-later https://raw.githubusercontent.com/jquery-form/form/master/LICENSE */
(function(factory){if(typeof define==='function'&&define.amd)define(['jquery'],factory);else if(typeof module==='object'&&module.exports)module.exports=function(root,jQuery){if(typeof jQuery==='undefined')if(typeof window!=='undefined')jQuery=require('jquery');else jQuery=require('jquery')(root);factory(jQuery);return jQuery;};else factory(jQuery);}(function($){'use strict';var rCRLF=/\r?\n/g;var feature={};feature.fileapi=$('<input type="file">').get(0).files!==undefined;feature.formdata=(typeof window.FormData!=='undefined');var hasProp=!!$.fn.prop;$.fn.attr2=function(){if(!hasProp)return this.attr.apply(this,arguments);var val=this.prop.apply(this,arguments);if((val&&val.jquery)||typeof val==='string')return val;return this.attr.apply(this,arguments);};$.fn.ajaxSubmit=function(options,data,dataType,onSuccess){if(!this.length){log('ajaxSubmit: skipping submit process - no element selected');return this;}var method,action,url,isMsie,iframeSrc,$form=this;if(typeof options==='function')options={success:options};else if(typeof options==='string'||(options===false&&arguments.length>0)){options={'url':options,'data':data,'dataType':dataType};if(typeof onSuccess==='function')options.success=onSuccess;}else{if(typeof options==='undefined')options={};}method=options.method||options.type||this.attr2('method');action=options.url||this.attr2('action');url=(typeof action==='string')?action.trim():'';url=url||window.location.href||'';if(url)url=(url.match(/^([^#]+)/)||[])[1];isMsie=/(MSIE|Trident)/.test(navigator.userAgent||'');iframeSrc=(isMsie&&/^https/i.test(window.location.href||''))?'javascript:false':'about:blank';options=$.extend(true,{url,success:$.ajaxSettings.success,type:method||$.ajaxSettings.type,iframeSrc},options);var veto={};this.trigger('form-pre-serialize',[this,options,veto]);if(veto.veto){log('ajaxSubmit: submit vetoed via form-pre-serialize trigger');return this;}if(options.beforeSerialize&&options.beforeSerialize(this,options)===false){log('ajaxSubmit: submit aborted via beforeSerialize callback');return this;}var traditional=options.traditional;if(typeof traditional==='undefined')traditional=$.ajaxSettings.traditional;var elements=[];var qx,a=this.formToArray(options.semantic,elements,options.filtering);if(options.data){var optionsData=typeof (options.data)==="function"?options.data(a):options.data;options.extraData=optionsData;qx=$.param(optionsData,traditional);}if(options.beforeSubmit&&options.beforeSubmit(a,this,options)===false){log('ajaxSubmit: submit aborted via beforeSubmit callback');return this;}this.trigger('form-submit-validate',[a,this,options,veto]);if(veto.veto){log('ajaxSubmit: submit vetoed via form-submit-validate trigger');return this;}var q=$.param(a,traditional);if(qx)q=(q?(q+'&'+qx):qx);if(options.type.toUpperCase()==='GET'){options.url+=(options.url.indexOf('?')>=0?'&':'?')+q;options.data=null;}else options.data=q;var callbacks=[];if(options.resetForm)callbacks.push(function(){$form.resetForm();});if(options.clearForm)callbacks.push(function(){$form.clearForm(options.includeHidden);});if(!options.dataType&&options.target){var oldSuccess=options.success||function(){};callbacks.push(function(data,textStatus,jqXHR){var successArguments=arguments,fn=options.replaceTarget?'replaceWith':'html';$(options.target)[fn](data).each(function(){oldSuccess.apply(this,successArguments);});});}else{if(options.success)if(Array.isArray(options.success))callbacks=callbacks.concat(options.success);else callbacks.push(options.success);}options.success=function(data,status,xhr){var context=options.context||this;for(var i=0,max=callbacks.length;i<max;i++)callbacks[i].apply(context,[data,status,xhr||$form,$form]);};if(options.error){var oldError=options.error;options.error=function(xhr,status,error){var context=options.context||this;oldError.apply(context,[xhr,status,error,$form]);};}if(options.complete){var oldComplete=options.complete;options.complete=function(xhr,status){var context=options.context||this;oldComplete.apply(context,[xhr,status,$form]);};}var fileInputs=$('input[type=file]:enabled',this).filter(function(){return $(this).val()!=='';});var hasFileInputs=fileInputs.length>0;var mp='multipart/form-data';var multipart=($form.attr('enctype')===mp||$form.attr('encoding')===mp);var fileAPI=feature.fileapi&&feature.formdata;log('fileAPI :'+fileAPI);var shouldUseFrame=(hasFileInputs||multipart)&&!fileAPI;var jqxhr;if(options.iframe!==false&&(options.iframe||shouldUseFrame))if(options.closeKeepAlive)$.get(options.closeKeepAlive,function(){jqxhr=fileUploadIframe(a);});else jqxhr=fileUploadIframe(a);else if((hasFileInputs||multipart)&&fileAPI)jqxhr=fileUploadXhr(a);else jqxhr=$.ajax(options);$form.removeData('jqxhr').data('jqxhr',jqxhr);for(var k=0;k<elements.length;k++)elements[k]=null;this.trigger('form-submit-notify',[this,options]);return this;function deepSerialize(extraData){var serialized=$.param(extraData,options.traditional).split('&');var len=serialized.length;var result=[];var i,part;for(i=0;i<len;i++){serialized[i]=serialized[i].replace(/\+/g,' ');part=serialized[i].split('=');result.push([decodeURIComponent(part[0]),decodeURIComponent(part[1])]);}return result;}function fileUploadXhr(a){var formdata=new FormData();for(var i=0;i<a.length;i++)formdata.append(a[i].name,a[i].value);if(options.extraData){var serializedData=deepSerialize(options.extraData);for(i=0;i<serializedData.length;i++)if(serializedData[i])formdata.append(serializedData[i][0],serializedData[i][1]);}options.data=null;var s=$.extend(true,{},$.ajaxSettings,options,{contentType:false,processData:false,cache:false,type:method||'POST'});if(options.uploadProgress)s.xhr=function(){var xhr=$.ajaxSettings.xhr();if(xhr.upload)xhr.upload.addEventListener('progress',function(event){var percent=0;var position=event.loaded||event.position;var total=event.total;if(event.lengthComputable)percent=Math.ceil(position/total*100);options.uploadProgress(event,position,total,percent);},false);return xhr;};s.data=null;var beforeSend=s.beforeSend;s.beforeSend=function(xhr,o){if(options.formData)o.data=options.formData;else o.data=formdata;if(beforeSend)beforeSend.call(this,xhr,o);};return $.ajax(s);}function fileUploadIframe(a){var form=$form[0],el,i,s,g,id,$io,io,xhr,sub,n,timedOut,timeoutHandle;var deferred=$.Deferred();deferred.abort=function(status){xhr.abort(status);};if(a)for(i=0;i<elements.length;i++){el=$(elements[i]);if(hasProp)el.prop('disabled',false);else el.removeAttr('disabled');}s=$.extend(true,{},$.ajaxSettings,options);s.context=s.context||s;id='jqFormIO'+new Date().getTime();var ownerDocument=form.ownerDocument;var $body=$form.closest('body');if(s.iframeTarget){$io=$(s.iframeTarget,ownerDocument);n=$io.attr2('name');if(!n)$io.attr2('name',id);else id=n;}else{$io=$('<iframe name="'+id+'" src="'+s.iframeSrc+'" />',ownerDocument);$io.css({position:'absolute',top:'-1000px',left:'-1000px'});}io=$io[0];xhr={aborted:0,responseText:null,responseXML:null,status:0,statusText:'n/a',getAllResponseHeaders:function(){},getResponseHeader:function(){},setRequestHeader:function(){},abort:function(status){var e=(status==='timeout'?'timeout':'aborted');log('aborting upload... '+e);this.aborted=1;try{if(io.contentWindow.document.execCommand)io.contentWindow.document.execCommand('Stop');}catch(ignore){}$io.attr('src',s.iframeSrc);xhr.error=e;if(s.error)s.error.call(s.context,xhr,e,status);if(g)$.event.trigger('ajaxError',[xhr,s,e]);if(s.complete)s.complete.call(s.context,xhr,e);}};g=s.global;if(g&&$.active++===0)$.event.trigger('ajaxStart');if(g)$.event.trigger('ajaxSend',[xhr,s]);if(s.beforeSend&&s.beforeSend.call(s.context,xhr,s)===false){if(s.global)$.active--;deferred.reject();return deferred;}if(xhr.aborted){deferred.reject();return deferred;}sub=form.clk;if(sub){n=sub.name;if(n&&!sub.disabled){s.extraData=s.extraData||{};s.extraData[n]=sub.value;if(sub.type==='image'){s.extraData[n+'.x']=form.clk_x;s.extraData[n+'.y']=form.clk_y;}}}var CLIENT_TIMEOUT_ABORT=1;var SERVER_ABORT=2;function getDoc(frame){var doc=null;try{if(frame.contentWindow)doc=frame.contentWindow.document;}catch(err){log('cannot get iframe.contentWindow document: '+err);}if(doc)return doc;try{doc=frame.contentDocument?frame.contentDocument:frame.document;}catch(err){log('cannot get iframe.contentDocument: '+err);doc=frame.document;}return doc;}var csrf_token=$('meta[name=csrf-token]').attr('content');var csrf_param=$('meta[name=csrf-param]').attr('content');if(csrf_param&&csrf_token){s.extraData=s.extraData||{};s.extraData[csrf_param]=csrf_token;}function doSubmit(){var t=$form.attr2('target'),a=$form.attr2('action'),mp='multipart/form-data',et=$form.attr('enctype')||$form.attr('encoding')||mp;form.setAttribute('target',id);if(!method||/post/i.test(method))form.setAttribute('method','POST');if(a!==s.url)form.setAttribute('action',s.url);if(!s.skipEncodingOverride&&(!method||/post/i.test(method)))$form.attr({encoding:'multipart/form-data',enctype:'multipart/form-data'});if(s.timeout)timeoutHandle=setTimeout(function(){timedOut=true;cb(CLIENT_TIMEOUT_ABORT);},s.timeout);function checkState(){try{var state=getDoc(io).readyState;log('state = '+state);if(state&&state.toLowerCase()==='uninitialized')setTimeout(checkState,50);}catch(e){log('Server abort: ',e,' (',e.name,')');cb(SERVER_ABORT);if(timeoutHandle)clearTimeout(timeoutHandle);timeoutHandle=undefined;}}var extraInputs=[];try{if(s.extraData)for(var n in s.extraData)if(s.extraData.hasOwnProperty(n))if($.isPlainObject(s.extraData[n])&&s.extraData[n].hasOwnProperty('name')&&s.extraData[n].hasOwnProperty('value'))extraInputs.push($('<input type="hidden" name="'+s.extraData[n].name+'">',ownerDocument).val(s.extraData[n].value).appendTo(form)[0]);else extraInputs.push($('<input type="hidden" name="'+n+'">',ownerDocument).val(s.extraData[n]).appendTo(form)[0]);if(!s.iframeTarget)$io.appendTo($body);if(io.attachEvent)io.attachEvent('onload',cb);else io.addEventListener('load',cb,false);setTimeout(checkState,15);try{form.submit();}catch(err){var submitFn=document.createElement('form').submit;submitFn.apply(form);}}finally{form.setAttribute('action',a);form.setAttribute('enctype',et);if(t)form.setAttribute('target',t);else $form.removeAttr('target');$(extraInputs).remove();}}if(s.forceSync)doSubmit();else setTimeout(doSubmit,10);var data,doc,domCheckCount=50,callbackProcessed;function cb(e){if(xhr.aborted||callbackProcessed)return;doc=getDoc(io);if(!doc){log('cannot access response document');e=SERVER_ABORT;}if(e===CLIENT_TIMEOUT_ABORT&&xhr){xhr.abort('timeout');deferred.reject(xhr,'timeout');return;}if(e===SERVER_ABORT&&xhr){xhr.abort('server abort');deferred.reject(xhr,'error','server abort');return;}if(!doc||doc.location.href===s.iframeSrc)if(!timedOut)return;if(io.detachEvent)io.detachEvent('onload',cb);else io.removeEventListener('load',cb,false);var status='success',errMsg;try{if(timedOut)throw 'timeout';var isXml=s.dataType==='xml'||doc.XMLDocument||$.isXMLDoc(doc);log('isXml='+isXml);if(!isXml&&window.opera&&(doc.body===null||!doc.body.innerHTML))if(--domCheckCount){log('requeing onLoad callback, DOM not available');setTimeout(cb,250);return;}var docRoot=doc.body?doc.body:doc.documentElement;xhr.responseText=docRoot?docRoot.innerHTML:null;xhr.responseXML=doc.XMLDocument?doc.XMLDocument:doc;if(isXml)s.dataType='xml';xhr.getResponseHeader=function(header){var headers={'content-type':s.dataType};return headers[header.toLowerCase()];};if(docRoot){xhr.status=Number(docRoot.getAttribute('status'))||xhr.status;xhr.statusText=docRoot.getAttribute('statusText')||xhr.statusText;}var dt=(s.dataType||'').toLowerCase();var scr=/(json|script|text)/.test(dt);if(scr||s.textarea){var ta=doc.getElementsByTagName('textarea')[0];if(ta){xhr.responseText=ta.value;xhr.status=Number(ta.getAttribute('status'))||xhr.status;xhr.statusText=ta.getAttribute('statusText')||xhr.statusText;}else{if(scr){var pre=doc.getElementsByTagName('pre')[0];var b=doc.getElementsByTagName('body')[0];if(pre)xhr.responseText=pre.textContent?pre.textContent:pre.innerText;else{if(b)xhr.responseText=b.textContent?b.textContent:b.innerText;}}}}else{if(dt==='xml'&&!xhr.responseXML&&xhr.responseText)xhr.responseXML=toXml(xhr.responseText);}try{data=httpData(xhr,dt,s);}catch(err){status='parsererror';xhr.error=errMsg=(err||status);}}catch(err){log('error caught: ',err);status='error';xhr.error=errMsg=(err||status);}if(xhr.aborted){log('upload aborted');status=null;}if(xhr.status)status=((xhr.status>=200&&xhr.status<300)||xhr.status===304)?'success':'error';if(status==='success'){if(s.success)s.success.call(s.context,data,'success',xhr);deferred.resolve(xhr.responseText,'success',xhr);if(g)$.event.trigger('ajaxSuccess',[xhr,s]);}else{if(status){if(typeof errMsg==='undefined')errMsg=xhr.statusText;if(s.error)s.error.call(s.context,xhr,status,errMsg);deferred.reject(xhr,'error',errMsg);if(g)$.event.trigger('ajaxError',[xhr,s,errMsg]);}}if(g)$.event.trigger('ajaxComplete',[xhr,s]);if(g&&!--$.active)$.event.trigger('ajaxStop');if(s.complete)s.complete.call(s.context,xhr,status);callbackProcessed=true;if(s.timeout)clearTimeout(timeoutHandle);setTimeout(function(){if(!s.iframeTarget)$io.remove();else $io.attr('src',s.iframeSrc);xhr.responseXML=null;},100);}var toXml=$.parseXML||function(s,doc){if(window.ActiveXObject){doc=new ActiveXObject('Microsoft.XMLDOM');doc.async='false';doc.loadXML(s);}else doc=(new DOMParser()).parseFromString(s,'text/xml');return (doc&&doc.documentElement&&doc.documentElement.nodeName!=='parsererror')?doc:null;};var httpData=function(xhr,type,s){var ct=xhr.getResponseHeader('content-type')||'',xml=((type==='xml'||!type)&&ct.indexOf('xml')>=0),data=xml?xhr.responseXML:xhr.responseText;if(xml&&data.documentElement.nodeName==='parsererror')if($.error)$.error('parsererror');if(s&&s.dataFilter)data=s.dataFilter(data,type);if(typeof data==='string')if((type==='json'||!type)&&ct.indexOf('json')>=0)data=JSON.parse(data);else{if((type==='script'||!type)&&ct.indexOf('javascript')>=0)$.globalEval(data);}return data;};return deferred;}};$.fn.ajaxForm=function(options,data,dataType,onSuccess){if(typeof options==='string'||(options===false&&arguments.length>0)){options={'url':options,'data':data,'dataType':dataType};if(typeof onSuccess==='function')options.success=onSuccess;}options=options||{};options.delegation=options.delegation&&typeof $.fn.on==='function';if(!options.delegation&&this.length===0){var o={s:this.selector,c:this.context};if(!$.isReady&&o.s){log('DOM not ready, queuing ajaxForm');$(function(){$(o.s,o.c).ajaxForm(options);});return this;}log('terminating; zero elements found by selector'+($.isReady?'':' (DOM not ready)'));return this;}if(options.delegation){$(document).off('submit.form-plugin',this.selector,doAjaxSubmit).off('click.form-plugin',this.selector,captureSubmittingElement).on('submit.form-plugin',this.selector,options,doAjaxSubmit).on('click.form-plugin',this.selector,options,captureSubmittingElement);return this;}if(options.beforeFormUnbind)options.beforeFormUnbind(this,options);return this.ajaxFormUnbind().on('submit.form-plugin',options,doAjaxSubmit).on('click.form-plugin',options,captureSubmittingElement);};function doAjaxSubmit(e){var options=e.data;if(!e.isDefaultPrevented()){e.preventDefault();$(e.target).closest('form').ajaxSubmit(options);}}function captureSubmittingElement(e){var target=e.target;var $el=$(target);if(!$el.is('[type=submit],[type=image]')){var t=$el.closest('[type=submit]');if(t.length===0)return;target=t[0];}var form=target.form;form.clk=target;if(target.type==='image')if(typeof e.offsetX!=='undefined'){form.clk_x=e.offsetX;form.clk_y=e.offsetY;}else if(typeof $.fn.offset==='function'){var offset=$el.offset();form.clk_x=e.pageX-offset.left;form.clk_y=e.pageY-offset.top;}else{form.clk_x=e.pageX-target.offsetLeft;form.clk_y=e.pageY-target.offsetTop;}setTimeout(function(){form.clk=form.clk_x=form.clk_y=null;},100);}$.fn.ajaxFormUnbind=function(){return this.off('submit.form-plugin click.form-plugin');};$.fn.formToArray=function(semantic,elements,filtering){var a=[];if(this.length===0)return a;var form=this[0];var formId=this.attr('id');var els=(semantic||typeof form.elements==='undefined')?form.getElementsByTagName('*'):form.elements;var els2;if(els)els=$.makeArray(els);if(formId&&(semantic||/(Edge|Trident)\//.test(navigator.userAgent))){els2=$(':input[form="'+formId+'"]').get();if(els2.length)els=(els||[]).concat(els2);}if(!els||!els.length)return a;if(typeof (filtering)==="function")els=$.map(els,filtering);var i,j,n,v,el,max,jmax;for(i=0,max=els.length;i<max;i++){el=els[i];n=el.name;if(!n||el.disabled)continue;if(semantic&&form.clk&&el.type==='image'){if(form.clk===el){a.push({name:n,value:$(el).val(),type:el.type});a.push({name:n+'.x',value:form.clk_x},{name:n+'.y',value:form.clk_y});}continue;}v=$.fieldValue(el,true);if(v&&v.constructor===Array){if(elements)elements.push(el);for(j=0,jmax=v.length;j<jmax;j++)a.push({name:n,value:v[j]});}else if(feature.fileapi&&el.type==='file'){if(elements)elements.push(el);var files=el.files;if(files.length)for(j=0;j<files.length;j++)a.push({name:n,value:files[j],type:el.type});else a.push({name:n,value:'',type:el.type});}else{if(v!==null&&typeof v!=='undefined'){if(elements)elements.push(el);a.push({name:n,value:v,type:el.type,required:el.required});}}}if(!semantic&&form.clk){var $input=$(form.clk),input=$input[0];n=input.name;if(n&&!input.disabled&&input.type==='image'){a.push({name:n,value:$input.val()});a.push({name:n+'.x',value:form.clk_x},{name:n+'.y',value:form.clk_y});}}return a;};$.fn.formSerialize=function(semantic){return $.param(this.formToArray(semantic));};$.fn.fieldSerialize=function(successful){var a=[];this.each(function(){var n=this.name;if(!n)return;var v=$.fieldValue(this,successful);if(v&&v.constructor===Array)for(var i=0,max=v.length;i<max;i++)a.push({name:n,value:v[i]});else{if(v!==null&&typeof v!=='undefined')a.push({name:this.name,value:v});}});return $.param(a);};$.fn.fieldValue=function(successful){for(var val=[],i=0,max=this.length;i<max;i++){var el=this[i];var v=$.fieldValue(el,successful);if(v===null||typeof v==='undefined'||(v.constructor===Array&&!v.length))continue;if(Array.isArray(v))val=val.concat(v);else val.push(v);}return val;};$.fieldValue=function(el,successful){var n=el.name,t=el.type,tag=el.tagName.toLowerCase();if(typeof successful==='undefined')successful=true;if(successful&&(!n||el.disabled||t==='reset'||t==='button'||(t==='checkbox'||t==='radio')&&!el.checked||(t==='submit'||t==='image')&&el.form&&el.form.clk!==el||tag==='select'&&el.selectedIndex===-1))return null;if(tag==='select'){var index=el.selectedIndex;if(index<0)return null;var a=[],ops=el.options;var one=(t==='select-one');var max=(one?index+1:ops.length);for(var i=(one?index:0);i<max;i++){var op=ops[i];if(op.selected&&!op.disabled){var v=op.value;if(!v)v=(op.attributes&&op.attributes.value&&!(op.attributes.value.specified))?op.text:op.value;if(one)return v;a.push(v);}}return a;}return $(el).val().replace(rCRLF,'\r\n');};$.fn.clearForm=function(includeHidden){return this.each(function(){$('input,select,textarea',this).clearFields(includeHidden);});};$.fn.clearFields=$.fn.clearInputs=function(includeHidden){var re=/^(?:color|date|datetime|email|month|number|password|range|search|tel|text|time|url|week)$/i;return this.each(function(){var t=this.type,tag=this.tagName.toLowerCase();if(re.test(t)||tag==='textarea')this.value='';else if(t==='checkbox'||t==='radio')this.checked=false;else if(tag==='select')this.selectedIndex=-1;else if(t==='file')if(/MSIE/.test(navigator.userAgent))$(this).replaceWith($(this).clone(true));else $(this).val('');else{if(includeHidden)if((includeHidden===true&&/hidden/.test(t))||(typeof includeHidden==='string'&&$(this).is(includeHidden)))this.value='';}});};$.fn.resetForm=function(){return this.each(function(){var el=$(this);var tag=this.tagName.toLowerCase();switch(tag){case 'input':this.checked=this.defaultChecked;case 'textarea':this.value=this.defaultValue;return true;case 'option':case 'optgroup':var select=el.parents('select');if(select.length&&select[0].multiple)if(tag==='option')this.selected=this.defaultSelected;else el.find('option').resetForm();else select.resetForm();return true;case 'select':el.find('option').each(function(i){this.selected=this.defaultSelected;if(this.defaultSelected&&!el[0].multiple){el[0].selectedIndex=i;return false;}});return true;case 'label':var forEl=$(el.attr('for'));var list=el.find('input,select,textarea');if(forEl[0])list.unshift(forEl[0]);list.resetForm();return true;case 'form':if(typeof this.reset==='function'||(typeof this.reset==='object'&&!this.reset.nodeType))this.reset();return true;default:el.find('form,input,label,select,textarea').resetForm();return true;}});};$.fn.enable=function(b){if(typeof b==='undefined')b=true;return this.each(function(){this.disabled=!b;});};$.fn.selected=function(select){if(typeof select==='undefined')select=true;return this.each(function(){var t=this.type;if(t==='checkbox'||t==='radio')this.checked=select;else{if(this.tagName.toLowerCase()==='option'){var $sel=$(this).parent('select');if(select&&$sel[0]&&$sel[0].type==='select-one')$sel.find('option').selected(false);this.selected=select;}}});};$.fn.ajaxSubmit.debug=false;function log(){if(!$.fn.ajaxSubmit.debug)return;var msg='[jquery.form] '+Array.prototype.join.call(arguments,'');if(window.console&&window.console.log)window.console.log(msg);else{if(window.opera&&window.opera.postError)window.opera.postError(msg);}}}));;
/* @license GPL-2.0-or-later https://www.drupal.org/licensing/faq */
(function($,_,Drupal,drupalSettings){"use strict";Drupal.behaviors.LayoutBuilderBlocksContentTab={attach:function(context){$('form.layout-builder-configure-block > :not(#bs_ui):not(.form-submit)').each(function(){$('form.layout-builder-configure-block > #bs_ui > #bs_tabContent > .bs_tab-pane--content').append($(this));});}};})(window.jQuery,window._,window.Drupal,window.drupalSettings);;
((Drupal)=>{Drupal.theme.checkbox=()=>`<input type="checkbox" class="form-checkbox"/>`;})(Drupal);;
(($,Drupal)=>{Drupal.behaviors.ClickToSelect={attach(context){$(once('media-library-click-to-select','.js-click-to-select-trigger',context)).on('click',(event)=>{event.preventDefault();const $input=$(event.currentTarget).closest('.js-click-to-select').find('.js-click-to-select-checkbox input');$input.prop('checked',!$input.prop('checked')).trigger('change');});$(once('media-library-click-to-select','.js-click-to-select-checkbox input',context)).on('change',({currentTarget})=>{$(currentTarget).closest('.js-click-to-select').toggleClass('checked',$(currentTarget).prop('checked'));}).on('focus blur',({currentTarget,type})=>{$(currentTarget).closest('.js-click-to-select').toggleClass('is-focus',type==='focus');});$(once('media-library-click-to-select-hover','.js-click-to-select-trigger, .js-click-to-select-checkbox',context)).on('mouseover mouseout',({currentTarget,type})=>{$(currentTarget).closest('.js-click-to-select').toggleClass('is-hover',type==='mouseover');});}};})(jQuery,Drupal);;
(($,Drupal)=>{Drupal.behaviors.MediaLibrarySelectAll={attach(context){const $view=$(once('media-library-select-all','.js-media-library-view[data-view-display-id="page"]',context));if($view.length&&$view.find('.js-media-library-item').length){const $checkbox=$(Drupal.theme('checkbox')).on('click',({currentTarget})=>{const $checkboxes=$(currentTarget).closest('.js-media-library-view').find('.js-media-library-item input[type="checkbox"]');$checkboxes.prop('checked',$(currentTarget).prop('checked')).trigger('change');const announcement=$(currentTarget).prop('checked')?Drupal.t('All @count items selected',{'@count':$checkboxes.length}):Drupal.t('Zero items selected');Drupal.announce(announcement);});const $label=$('<label class="media-library-select-all"></label>');$label[0].textContent=Drupal.t('Select all media');$label.prepend($checkbox);$view.find('.js-media-library-item').first().before($label);}}};})(jQuery,Drupal);;
(($,Drupal,Sortable)=>{"use strict";Drupal.behaviors.MediaLibraryFormElementEditItem={attach:function attach(context){const itemSelector='.media-library-form-element .js-media-library-item a[href]';$(once('media-library-edit',itemSelector,context)).each(function(index){var elementSettings={progress:{type:"throbber"},dialogType:"modal",dialog:{width:"80%"},dialogRenderer:null,base:$(this).attr("id"),element:this,url:$(this).attr("href"),event:"click"};Drupal.ajax(elementSettings);});}};Drupal.behaviors.MediaLibraryFormElementDisableButton={attach(context){const itemSelector='.js-media-library-open-button[data-disabled-focus="true"]';$(once('media-library-disable',itemSelector,context)).each(function(index){$(this).focus();setTimeout(()=>{$(this).attr("disabled","disabled");},50);});}};Drupal.behaviors.MediaLibraryFormElementToggleWeight={attach(context){const strings={show:Drupal.t("Show media item weights"),hide:Drupal.t("Hide media item weights")};$(once('media-library-toggle','.js-media-library-widget-toggle-weight',context)).each(function(index){$(this).on('click',(e)=>{e.preventDefault();$(e.currentTarget).toggleClass('active').text($(e.currentTarget).hasClass('active')?strings.hide:strings.show).closest('.js-media-library-widget').find('.js-media-library-item-weight').parent().toggle();}).text(strings.show);});$(once('media-library-toggle','.js-media-library-item-weight',context)).each(function(index){$(this).parent().hide();});}};Drupal.behaviors.MediaLibraryFormElementSortable={attach(context){const selection=context.querySelectorAll(".js-media-library-selection");selection.forEach((widget)=>{Sortable.create(widget,{draggable:".js-media-library-item",handle:".js-media-library-item-preview",onEnd:()=>{$(widget).children().each((index,child)=>{$(child).find(".js-media-library-item-weight").val(index);});}});});}};$.fn.setMediaUploadFieldValue=function(data,element){const currentValue=$(element).val();$(element).val(`${currentValue}${currentValue===""?"":","}${data}`);};})(jQuery,Drupal,Sortable);;
